/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.core;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nyfaria.numismaticoverhaul.owostuff.renderdoc.RenderDoc;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.CursorStyle;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ParentComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.Drawer;
import java.util.EnumMap;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import org.lwjgl.glfw.GLFW;

public class OwoUIAdapter<T extends ParentComponent>
implements GuiEventListener,
Widget,
NarratableEntry {
    private static boolean isRendering = false;
    public final T rootComponent;
    public final EnumMap<CursorStyle, Long> cursors = new EnumMap(CursorStyle.class);
    protected CursorStyle lastCursorStyle = CursorStyle.POINTER;
    protected boolean disposed = false;
    protected boolean captureFrame = false;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    public boolean enableInspector = false;
    public boolean globalInspector = false;
    public int inspectorZOffset = 1000;

    protected OwoUIAdapter(int x, int y, int width, int height, T rootComponent) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        for (CursorStyle style : CursorStyle.values()) {
            this.cursors.put(style, GLFW.glfwCreateStandardCursor((int)style.glfw));
        }
        this.rootComponent = rootComponent;
    }

    public static <T extends ParentComponent> OwoUIAdapter<T> create(Screen screen, BiFunction<Sizing, Sizing, T> rootComponentMaker) {
        ParentComponent rootComponent = (ParentComponent)rootComponentMaker.apply(Sizing.fill(100), Sizing.fill(100));
        OwoUIAdapter<ParentComponent> adapter = new OwoUIAdapter<ParentComponent>(0, 0, screen.f_96543_, screen.f_96544_, rootComponent);
        screen.m_142416_(adapter);
        screen.m_94725_(adapter);
        return adapter;
    }

    public static <T extends ParentComponent> OwoUIAdapter<T> createWithoutScreen(int x, int y, int width, int height, BiFunction<Sizing, Sizing, T> rootComponentMaker) {
        ParentComponent rootComponent = (ParentComponent)rootComponentMaker.apply(Sizing.fill(100), Sizing.fill(100));
        return new OwoUIAdapter<ParentComponent>(x, y, width, height, rootComponent);
    }

    public void inflateAndMount() {
        this.rootComponent.inflate(Size.of(this.width, this.height));
        this.rootComponent.mount(null, this.x, this.y);
    }

    public void moveAndResize(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.inflateAndMount();
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.cursors.values().forEach(GLFW::glfwDestroyCursor);
        this.disposed = true;
    }

    public boolean toggleInspector() {
        this.enableInspector = !this.enableInspector;
        return this.enableInspector;
    }

    public boolean toggleGlobalInspector() {
        this.globalInspector = !this.globalInspector;
        return this.globalInspector;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        try {
            isRendering = true;
            if (this.captureFrame) {
                RenderDoc.startFrameCapture();
            }
            float delta = Minecraft.m_91087_().m_91297_();
            Window window = Minecraft.m_91087_().m_91268_();
            this.rootComponent.update(delta, mouseX, mouseY);
            RenderSystem.m_69482_();
            GlStateManager.m_84501_();
            GlStateManager.m_84168_((int)0, (int)0, (int)window.m_85441_(), (int)window.m_85442_());
            this.rootComponent.draw(matrices, mouseX, mouseY, partialTicks, delta);
            GlStateManager.m_84495_();
            RenderSystem.m_69465_();
            this.rootComponent.drawTooltip(matrices, mouseX, mouseY, partialTicks, delta);
            ModComponent hovered = this.rootComponent.childAt(mouseX, mouseY);
            if (!this.disposed && hovered != null && hovered.cursorStyle() != this.lastCursorStyle) {
                GLFW.glfwSetCursor((long)window.m_85439_(), (long)this.cursors.get((Object)hovered.cursorStyle()));
                this.lastCursorStyle = hovered.cursorStyle();
            }
            if (this.enableInspector) {
                matrices.m_85837_(0.0, 0.0, (double)this.inspectorZOffset);
                Drawer.debug().drawInspector(matrices, (ParentComponent)this.rootComponent, mouseX, mouseY, !this.globalInspector);
                matrices.m_85837_(0.0, 0.0, (double)(-this.inspectorZOffset));
            }
            if (this.captureFrame) {
                RenderDoc.endFrameCapture();
            }
        }
        finally {
            isRendering = false;
            this.captureFrame = false;
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.rootComponent.isInBoundingBox(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.rootComponent.onMouseDown(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.rootComponent.onMouseUp(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return this.rootComponent.onMouseScroll(mouseX, mouseY, amount);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.rootComponent.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.rootComponent.onKeyPress(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        return this.rootComponent.onCharTyped(chr, modifiers);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput builder) {
    }

    public static boolean isRendering() {
        return isRendering;
    }
}

